# stpncpy.m4 serial 1
dnl Copyright (C) 2002-2003 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([gl_FUNC_STPNCPY],
[
  dnl Persuade glibc <string.h> to declare stpncpy().
  AC_REQUIRE([AC_GNU_SOURCE])

  dnl Both glibc and AIX (4.3.3, 5.1) have an stpncpy() function
  dnl declared in <string.h>. Its side effects are the same as those
  dnl of strncpy():
  dnl      stpncpy (dest, src, n)
  dnl overwrites dest[0..n-1], min(strlen(src),n) bytes coming from src,
  dnl and the remaining bytes being NULs.  However, the return value is
  dnl   in glibc:   dest + min(strlen(src),n)
  dnl   in AIX:     dest + max(0,n-1)
  dnl Only the glibc return value is useful in practice.

  AC_CACHE_CHECK([for working stpncpy], gl_cv_func_stpncpy, [
    AC_TRY_RUN([
#include <stdlib.h>
extern char *stpncpy (char *dest, const char *src, size_t n);
int main () {
  const char *src = "Hello";
  char dest[10];
  /* AIX 4.3.3 and AIX 5.1 stpncpy() returns dest+1 here.  */
  strcpy (dest, "\377\377\377\377\377\377");
  if (stpncpy (dest, src, 2) != dest + 2) exit(1);
  /* AIX 4.3.3 and AIX 5.1 stpncpy() returns dest+4 here.  */
  strcpy (dest, "\377\377\377\377\377\377");
  if (stpncpy (dest, src, 5) != dest + 5) exit(1);
  /* AIX 4.3.3 and AIX 5.1 stpncpy() returns dest+6 here.  */
  strcpy (dest, "\377\377\377\377\377\377");
  if (stpncpy (dest, src, 7) != dest + 5) exit(1);
  exit(0);
}
], gl_cv_func_stpncpy=yes, gl_cv_func_stpncpy=no,
  [AC_EGREP_CPP([Thanks for using GNU], [
#include <features.h>
#ifdef __GNU_LIBRARY__
  Thanks for using GNU
#endif
], gl_cv_func_stpncpy=yes, gl_cv_func_stpncpy=no)])])

  if test $gl_cv_func_stpncpy = yes; then
    AC_DEFINE(HAVE_STPNCPY, 1,
      [Define if you have the stpncpy() function and it works.])
  else
    AC_LIBOBJ([stpncpy])
    gl_PREREQ_STPNCPY
  fi
])

# Prerequisites of lib/stpncpy.c.
AC_DEFUN([gl_PREREQ_STPNCPY], [
  :
])

